/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core;

import com.aptana.core.ShellExecutable;
import com.aptana.core.diagnostic.IDiagnosticLog;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodeJSService;
import com.aptana.js.core.node.INodePackageManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class JSDiagnosticLog
implements IDiagnosticLog {
    public String getLog() {
        String nodeJSVersion;
        StringBuilder buf = new StringBuilder();
        INodeJSService service = JSCorePlugin.getDefault().getNodeJSService();
        INodeJS nodeJS = service.getValidExecutable();
        String version = "Not installed";
        if (nodeJS != null && !StringUtil.isEmpty((String)(nodeJSVersion = nodeJS.getVersion()))) {
            version = nodeJSVersion;
        }
        buf.append("Node.JS Version: ").append(version).append(FileUtil.NEW_LINE);
        INodePackageManager npm = nodeJS == null ? null : nodeJS.getNPM();
        String pathString = "Not installed";
        if (npm != null && npm.exists()) {
            pathString = npm.getPath().toOSString();
        }
        buf.append("NPM Path: ").append(pathString).append(FileUtil.NEW_LINE);
        if (npm != null && npm.exists()) {
            try {
                String npmVersion = npm.getVersion();
                buf.append("NPM Version: ").append(npmVersion).append(FileUtil.NEW_LINE);
                String highLevelPackages = this.getInstalledNpmPackages(npm);
                buf.append(highLevelPackages);
                buf.append(FileUtil.NEW_LINE);
                IStatus titaniumStatus = npm.runInBackground("-g", "ls", "titanium");
                String npmVersionOutput = titaniumStatus.getMessage();
                buf.append("npm -g ls titanium: ").append(npmVersionOutput).append(FileUtil.NEW_LINE);
                IStatus listStatus = npm.runInBackground("-g", "list");
                String listOutput = listStatus.getMessage();
                buf.append("Packages: ").append(listOutput).append(FileUtil.NEW_LINE);
                buf.append("NPM_CONFIG_PREFIX env value: " + (String)ShellExecutable.getEnvironment().get("NPM_CONFIG_PREFIX")).append(FileUtil.NEW_LINE);
                String configPrefixValue = JSCorePlugin.getDefault().getNodePackageManager().getConfigValue("prefix");
                buf.append("Npm config prefix value : ").append(configPrefixValue).append(FileUtil.NEW_LINE);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    private String getInstalledNpmPackages(INodePackageManager npm) throws CoreException {
        IStatus status = npm.runInBackground("-g", "list", "--depth=0");
        String listOutput = status.getMessage();
        int errIndex = listOutput.indexOf("npm ERR!");
        if (errIndex != -1) {
            listOutput = listOutput.substring(0, errIndex);
        }
        return listOutput;
    }
}

